# 🚀 日本語文章処理ポータル - Cloudflare Pages デプロイガイド

## 📦 プロジェクトバックアップ
- **バックアップURL**: https://page.gensparksite.com/project_backups/tooluse_dIQ3ly_0SUur15GyQabdXQ.tar.gz
- **ファイル名**: japanese-text-portal-backup.tar.gz
- **サイズ**: 75.6KB

## 🌐 Cloudflare Pages 手動デプロイ手順

### 方法1: Cloudflare Dashboard経由（推奨）

1. **Cloudflare Dashboardにログイン**
   - https://dash.cloudflare.com にアクセス
   - お使いのアカウントでログイン

2. **Pages プロジェクトを作成**
   - 左側メニュー「Workers & Pages」を選択
   - 「Create application」→「Pages」を選択
   - 「Upload assets」を選択

3. **プロジェクト設定**
   - プロジェクト名: `japanese-text-portal`
   - Production branch: `main`

4. **ファイルのアップロード**
   - バックアップファイルをダウンロード・解凍
   - `dist/` フォルダの内容をアップロード
   - 以下のファイルが含まれているか確認:
     ```
     dist/
     ├── _worker.js      # メインアプリケーション
     ├── _routes.json    # ルーティング設定
     └── static/         # 静的ファイル
         └── style.css
     ```

### 方法2: Wrangler CLI経由（権限設定後）

1. **APIトークン権限の確認・更新**
   - Cloudflare Dashboard → API Tokens
   - 以下の権限が必要:
     - Zone:Zone:Edit
     - Account:Cloudflare Pages:Edit
     - Zone:Zone Settings:Edit

2. **デプロイコマンド**
   ```bash
   cd /path/to/extracted/webapp
   npm install
   npm run build
   npx wrangler pages deploy dist --project-name japanese-text-portal
   ```

## 🔧 プロジェクト設定詳細

### wrangler.jsonc 設定
```jsonc
{
  "$schema": "node_modules/wrangler/config-schema.json", 
  "name": "japanese-text-portal",
  "compatibility_date": "2025-09-09",
  "pages_build_output_dir": "./dist",
  "compatibility_flags": ["nodejs_compat"]
}
```

### 予想される本番URLs
- **プロダクション**: `https://japanese-text-portal.pages.dev`
- **ブランチ**: `https://main.japanese-text-portal.pages.dev`

## 📋 含まれるサービス情報

1. **あゆみ所見自動生成システム**
   - URL: https://ayumi-soken-vercel.vercel.app/

2. **あゆみ所見等 自動校正システム**  
   - URL: https://romania0310-art.github.io/kousei-system/

3. **AI活用！文章自動校正システム**
   - URL: https://japanese-proofreading-system.onrender.com

## 🛠️ 技術仕様

- **フレームワーク**: Hono v4.9.6
- **デプロイ先**: Cloudflare Pages
- **ビルドツール**: Vite v6.3.6
- **ランタイム**: Cloudflare Workers
- **言語**: TypeScript + JSX

## 📞 サポート

デプロイに関する質問や問題がございましたら、以下の情報をお知らせください:
- エラーメッセージ（あれば）
- デプロイ方法（Dashboard or CLI）
- 表示される状況の詳細

---
*日本語文章処理ポータル | あゆみシステム統合 | 2025年1月*