# 文章処理ポータル | あゆみシステム

## プロジェクト概要
- **名前**: 文章処理ポータル
- **目標**: 3つの日本語文章処理システムへの統一アクセスポータル
- **特徴**: 
  - あゆみ所見自動生成システム
  - あゆみ所見等自動校正システム  
  - AI活用文章自動校正システム
  - 教育現場での効率的な文章作成支援

## URLs
- **開発サーバー**: https://3000-i3x1g0xvt6708zds3any4-6532622b.e2b.dev
- **APIエンドポイント**: `/api/services` - サービス情報のJSON取得

## 統合サービス

### 1. あゆみ所見自動生成システム
- **URL**: https://ayumi-soken-vercel.vercel.app/
- **機能**: 学生の活動記録から個別の所見を自動生成
- **特徴**: 自動生成、個別対応、時間短縮

### 2. あゆみ所見等 自動校正システム
- **URL**: https://romania0310-art.github.io/kousei-system/
- **機能**: あゆみの所見文章を自動で校正・チェック
- **特徴**: 自動校正、誤字チェック、文体調整

### 3. AI活用！文章自動校正システム
- **URL**: https://japanese-proofreading-system.onrender.com
- **機能**: AI技術を活用した高精度な文章校正
- **特徴**: AI校正、高精度、多様な文章対応

## データアーキテクチャ
- **データモデル**: サービス情報管理（ID、タイトル、説明、URL、機能リスト）
- **ストレージサービス**: 現在は静的データ（将来的にCloudflare KVで拡張可能）
- **データフロー**: ポータル → 外部サービスへのリンク

## 利用ガイド

### 所見作成の推奨フロー
1. **あゆみ所見自動生成システム**で下書きを作成
2. **あゆみ所見校正システム**で内容をチェック・調整
3. 必要に応じて**AI校正システム**で最終確認

### システムの特徴
- 学校業務に特化した所見生成・校正
- AI技術による高精度な文章処理
- 作業時間の大幅な短縮
- 質の高い文章作成サポート

## 開発・デプロイ

### ローカル開発
```bash
npm install
npm run build
npm run dev:sandbox  # サンドボックス環境用
```

### API機能
- `/api/services` - 全サービス情報をJSON形式で取得

### Cloudflareデプロイ
```bash
npm run deploy:prod
```

### PM2管理（サンドボックス用）
```bash
pm2 start ecosystem.config.cjs  # 開始
pm2 logs webapp --nostream      # ログ確認
pm2 restart webapp              # 再起動
pm2 delete webapp               # 停止・削除
```

## 技術スタック
- **フレームワーク**: Hono (Cloudflare Workers対応)
- **フロントエンド**: TailwindCSS, FontAwesome
- **デプロイ**: Cloudflare Pages
- **言語**: TypeScript + JSX
- **最終更新**: 2025-01-09
